

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using com.caen.RFIDLibrary;
using ZedGraph;
using System.IO;



namespace TempLog
{
    

    public partial class Form1 : Form
    {
        

        CAENRFIDReader Reader  = new CAENRFIDReader();
        CAENRFIDLogicalSource LS_0;
        CAENRFIDTag[] Tags;
        short SAM_ENTRY_SZ = 6;
        short RES_MB = 0;
        short EPC_MB = 1;
        short TID_MB = 2;
        short USER_MB = 3;
        short RESERVED_NOTE = 32;
        short SAM_OF = 4;
        short FWR_OF = 8;
        short SERNUM_OF = 10;
        short S_TYPE_OF = 0;
        short S_ATTR_OF = 1;
        short S_SUBS_OF = 2;
        short S_RESL_OF = 3;
        short S_DTTY_OF = 4;
        short S_TOLR_OF = 5;
        short S_OFFS_OF = 6;
        short S_LLIM_OF = 8;
        short S_HLIM_OF = 10;
        short S_STAT_OF = 12;
        short S_CTRL_OF = 14;
        short S_STTI_OF = 16;
        short S_SAMN_OF = 20;
        short S_SAMI_OF = 22;
        short S_LTHR_OF = 24;
        short S_HTHR_OF = 26;
        short S_LAST_OF = 28;
        short S_DATA_OF = 32;
        short S_CHARPLUSCONFSIZE = 16;
        GraphPane myPane;
        PointPairList list;
        LineItem myCurve;
        int SamplingTime = 0;
        int StoreTime = 0;
        CAENRFIDTag SensorTag;
        short[] Sens_MemRange = new short[5];
        short[] Sens_Addr = new short[5];
        short[] Sens_MemBank = new short[5];
        double[] Samples;
        int SampleNo = 0;
        String[] DataStream;
        StreamWriter TestFile;
        
        static DateTime ConvertFromUnixTimestamp(long timestamp)
        {
            DateTime origin = new DateTime(1970, 1, 1, 0, 0, 0, 0);
            return origin.AddSeconds(timestamp);
        }
        
        static long ConvertToUnixTimestamp(DateTime date)
        {
            DateTime origin = new DateTime(1970, 1, 1, 0, 0, 0, 0);
            TimeSpan diff = date - origin;
            return (long)Math.Floor(diff.TotalSeconds);
        }
        
        public Form1()
        {
            //#define Production false 
            InitializeComponent();
            myPane = zg1.GraphPane;
            

            // Set the titles and axis labels
            myPane.Title.Text = "Temperature Graph";
            myPane.XAxis.Title.Text = "Sample, Time";
            myPane.YAxis.Title.Text = "Temperature (C)";

            myPane.XAxis.Scale.MajorStep = 8;
            myPane.XAxis.Scale.MajorUnit = DateUnit.Second;
            
            // tilt the x axis labels to an angle of 65 degrees
            
            myPane.XAxis.Scale.FontSpec.Angle = 90;
            myPane.XAxis.Scale.FontSpec.IsBold = true;
            myPane.XAxis.Scale.FontSpec.Size = 10;
            myPane.XAxis.Scale.Format = "dd/MM/yy HH:mm:ss" ;
             
            // Set the XAxis to date type
            myPane.XAxis.Type = AxisType.Date;
            list = new PointPairList();
            myCurve = myPane.AddCurve("Temp",list, Color.Blue, SymbolType.Circle);
            cConnType.SelectedIndex = 0;
            //Initialize the ViewGrid Memory in EPC C1G2 operations Tab
            for (short i = 0; i < 8; i++)
            {
                dGVMemDisplay.Rows.Add();
            }

            tBankRead.SelectedIndex    = 3;
            tBankWrite.SelectedIndex   = 3;
            tBankLock.SelectedIndex    = 3;
            cBLockAction.SelectedIndex = 0;
            /*
            #if (Production)
                 SerNumProg.Visible = true;
            #else
                 SerNumProg.Visible = false;
            #endif
            */
        }

        private byte[] ReadWithRetry(CAENRFIDTag tag, short bank, short address, short bytes, int Password)
        {
            int errn = 0;
            byte[] data;

            while (true)
            {
                try
                {
                    data = LS_0.ReadTagData_EPC_C1G2(tag, bank, address, bytes, Password);
                    return data;
                }
                catch (Exception ex)
                {
                    errn++;
                    lErr.Text = Convert.ToString(Convert.ToInt32(lErr.Text) + 1);
                    if (errn == 10)
                        throw ex;
                }
            }
        }

        
        private byte[] ReadWithRetry(CAENRFIDTag tag, short bank, short address, short bytes)
        {
            int errn = 0;
            byte[] data;

            while (true)
            {
                try
                {
                    data = LS_0.ReadTagData_EPC_C1G2(tag, bank, address, bytes);
                    return data;
                }
                catch (Exception ex)
                {
                    errn++;
                    lErr.Text = Convert.ToString(Convert.ToInt32(lErr.Text) + 1);
                    if (errn == 10) 
                        throw ex;
                }
            }
        }

        private void WriteWithRetry(CAENRFIDTag tag, short bank, short address, short bytes, byte[] data, int Password)
        {
            int errn = 0;

            while (true)
            {
                try
                {
                    LS_0.WriteTagData_EPC_C1G2(tag, bank, address, bytes, data, Password);
                    return;
                }
                catch (Exception ex)
                {
                    errn++;
                    lErr.Text = Convert.ToString(Convert.ToInt32(lErr.Text) + 1);
                    if (errn == 10)
                        throw ex;
                }
            }
        }

        private void WriteWithRetry(CAENRFIDTag tag, short bank, short address, short bytes, byte[] data)
        {
            int errn = 0;

            while (true)
            {
                try
                {
                    LS_0.WriteTagData_EPC_C1G2(tag, bank, address, bytes, data);
                    return;
                }
                catch (Exception ex)
                {
                    errn++;
                    lErr.Text = Convert.ToString(Convert.ToInt32(lErr.Text) + 1);
                    if (errn == 10)
                        throw ex;
                }
            }
        }

        private void bConnect_Click_1(object sender, EventArgs e)
        {
            string Address;
            CAENRFIDPort Port;

            if (bConnect.Text.Equals("Connect"))
            {
                if (cConnType.Text.Equals("TCP/IP"))
                {
                    Port = CAENRFIDPort.CAENRFID_TCP;
                    Address = tAddress.Text;
                }
                else
                {
                    Port = CAENRFIDPort.CAENRFID_RS232;
                    Address = tAddress.Text + ":115200:n:8:1";
                }
                try
                {
                    // Connect to the reader
                    //Reader.ConnectRS232("COM1", 19200);
                    Reader.Connect(Port, Address);
                    // Set the appropriate protocol (Gen2)
                    Reader.SetProtocol(CAENRFIDProtocol.CAENRFID_EPC_C1G2);
                    // Work on the default Source_0 (only Antenna 0)
                    Reader.SetBitRate(CAENRFIDBitRate.TX40RX40);
                    LS_0 = Reader.GetSource("Source_0");
                    bConnect.Text = "Disconnect";
                    bInventory.Enabled = true;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
            else
            {
                bCfgSend.Enabled = false;
                bInventory.Enabled = false;              
                SensorNum_CB.Enabled = false;
                bDown.Enabled = false;
                PAccessCommands.Enabled = false;
                Reader.Disconnect();
                bConnect.Text = "Connect";
            }
        }

        private String getStringID(CAENRFIDTag Tag)
        {

            int j;
            String s = "";
            String r = "";

            s = System.BitConverter.ToString(Tag.GetId());
            for (j = 0; j < s.Length; j++)
            {
                if (!s.Substring(j, 1).Equals("-")) r += s.Substring(j, 1);
            }
            return r;
        }

        private void bInventory_Click_1(object sender, EventArgs e)
        {
            int TagNum = 0, i,j;
            String Current;
            ListViewItem ListView;

            try
            {
                lstTags.Clear();
                Tags = LS_0.InventoryTag();
                if (Tags == null)
                {
                    MessageBox.Show("No tags detected !", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    TagNum = 0;
                }
                else
                {
                    

                    TagNum = Tags.Length;
                    for (i = 0; i < Tags.Length; i++)
                    {
                        byte[] data;
                        int Year = 0;
                        int Month;
                        int DayNum;
                        int SNCode;

                        
                        Current = getStringID(Tags[i]);
                        ListView = new ListViewItem();
                        ListView.Text = getStringID(Tags[i]);
                        ListView.Tag = Tags[i];
                        data = ReadWithRetry(Tags[i], TID_MB, 0, 4);
                        if ( (data[2] == 0x53) && (data[3] == 0x58)    )
                        {
                            data = ReadWithRetry(Tags[i], TID_MB, FWR_OF, 18);
                            Year = (((ushort)data[12]) << 8) + (ushort)data[13];
                            Month = data[14];
                            DayNum = data[15];
                            SNCode = (((ushort)data[16]) << 8) + (ushort)data[17];
                            ListView.ForeColor = Color.Blue;
                            ListView.ToolTipText = "TAG SN  : " + Year.ToString("d4") + Month.ToString(("d2")) + DayNum.ToString(("d2")) + SNCode.ToString(("d4")) + "\n\r" +
                                                   "TAG FWR : " + data[0].ToString() + "." + data[1].ToString();
                            if (data[0] == 0xFF)
                            {
                                ListView.ToolTipText = ListView.ToolTipText + "\n\r" + "Warning !!! Prototype tag";
                                ListView.ForeColor = Color.Black;
                            }
                        }
                        else
                        {
                            ListView.ForeColor = Color.Red;
                        }
                        lstTags.Items.Add(ListView);
                     }
                }

                bCfgSend.Enabled = false;
                SensorNum_CB.Enabled = false;
                bDown.Enabled = false;
                PAccessCommands.Enabled = false;
                tagInfoToolStripMenuItem.Enabled = false;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }


        private void bDownload_Click(object sender, EventArgs e)
        {
            byte[] data;
            int sample_16bit;
            short tMin, tMax;
            int   sensor;
            int   index;
            int   address;
            int   CurrPos;
            int   WordNum;
            int   logmem_size;
            long  StartTime;
            int   SamplingTime;
            int   LostSample;
            DateTime Time;
            bool TimeLog = false;
            

            pb1.Value = 0;

            sensor = SensorNum_CB.SelectedIndex;
            try
            {

                // Read the sensor's limits
                data = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_LLIM_OF), 2);
                tMin = (short)(data[1] + (data[0] << 8));
                data = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_HLIM_OF), 2);
                tMax = (short)(data[1] + (data[0] << 8));

                // Read the sensor's sample counter
                data = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_SAMN_OF), 2);
                SampleNo = data[1] + (data[0] << 8);
                short BytesToRead = 32;

                lErr.Text = "0";

                index = 0;
                address = Sens_Addr[sensor] + S_DATA_OF;

                logmem_size  = Sens_MemRange[sensor] - S_CHARPLUSCONFSIZE;

                data    = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_LAST_OF + 2), 2);
                CurrPos = ((int)((((short)data[0]) << 8) + (short)data[1]) + 1);

                // Read the sensor's start timer
                data = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_STTI_OF), 4);
                StartTime = data[3] + (data[2] << 8) + (data[1] << 16) + (data[0] << 24);

                // Read the sensor's sampling interval
                data = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_SAMI_OF), 2);
                SamplingTime = (data[1] + (data[0] << 8));

                //Read the sensor's control register
                data = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_CTRL_OF), 2);

                // Check if TimeLog is activated
                if ((data[1] & 0x60) == 0x60)
                {
                    TimeLog = true;
                    if (SampleNo > (logmem_size / 4))
                    {
                        LostSample = SampleNo - (logmem_size / 4 - (256 - (CurrPos % 256)) / 4);
                        StartTime = StartTime + LostSample * SamplingTime; 
                        SampleNo = (logmem_size / 4 - (256 - (CurrPos % 256)) / 4);
                    }
                    WordNum = SampleNo * 4;
                }
                else
                {
                    if (SampleNo > logmem_size)
                    {
                        LostSample = SampleNo - (logmem_size - (256-(CurrPos % 256)));
                        StartTime = StartTime + LostSample * SamplingTime; 
                        SampleNo   = (logmem_size - (256 - (CurrPos % 256)));
                    }
                    WordNum = SampleNo;
                }

                Samples = new double[WordNum];

                pb1.Minimum = 0;
                pb1.Maximum = WordNum;
    
                // Get the data from the log starting from 0 up to the current position
                for (int i = 0; i < CurrPos - (CurrPos % (BytesToRead / 2)); i += BytesToRead / 2)
                {
                    byte[] Temp = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)address, BytesToRead);
                    for (int j = 0; j < BytesToRead / 2; j++)
                    {
                        sample_16bit = ((((int)Temp[j * 2]) << 8) + (int)Temp[j * 2 + 1]);
                        Samples[WordNum - CurrPos + (index + j)] = ((double)(sample_16bit));
                    }
                    index = index + BytesToRead / 2;
                    address = address + BytesToRead;
                    pb1.Value = i + BytesToRead / 2;
                    Application.DoEvents();
                }

                

                {   if (((CurrPos * 2) % BytesToRead) != 0)
                      {
                      
                          byte[] Temp = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)address, (short)((CurrPos * 2) % BytesToRead));

                       for (int j = 0; j < CurrPos % (BytesToRead/2) ; j++)
                          {
                           sample_16bit = ((((int)Temp[j * 2]) << 8) + (int)Temp[j * 2 + 1]);
                           Samples[WordNum - CurrPos + (index + j)] = ((double)(sample_16bit));
                           pb1.Value = pb1.Value + 1;
                           Application.DoEvents();
                          }
                       address = address + (short)((CurrPos * 2) % BytesToRead);
                      }
                }

                
                
                if (MemFull_CB.Checked == true)
                {
                    index      = 0;
                    address    = address +  (256-(CurrPos % 256))*2;
                    WordNum = (WordNum - CurrPos);
                    // Get the data from the log starting from 0 up to the current position
                    for (int i = 0; i < WordNum - (WordNum % (BytesToRead / 2)); i += BytesToRead / 2)
                    {
                        byte[] Temp = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)address, BytesToRead);
                        for (int j = 0; j < BytesToRead / 2; j++)
                        {
                            sample_16bit = ((((int)Temp[j * 2]) << 8) + (int)Temp[j * 2 + 1]);
                            Samples[(index + j)] = ((double)(sample_16bit));
                        }
                        index = index + BytesToRead / 2;
                        address = address + BytesToRead;
                        pb1.Value = pb1.Value + BytesToRead / 2;
                        Application.DoEvents();
                    }

                    {
                        if (((WordNum * 2) % BytesToRead) != 0)
                        {

                            byte[] Temp = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)address, (short)((WordNum * 2) % BytesToRead));

                            for (int j = 0; j < WordNum % (BytesToRead / 2); j++)
                            {
                                sample_16bit = ((((int)Temp[j * 2]) << 8) + (int)Temp[j * 2 + 1]);
                                Samples[(index + j)] = ((double)(sample_16bit));
                                pb1.Value = pb1.Value + 1;
                                Application.DoEvents();
                            }
                        }
                    }
                   
                }

                myPane.CurveList["Temp"].Clear();

                if (DataStream != null)
                {
                    DataStream = null;
                    System.GC.Collect();
                }

                DataStream = new String[SampleNo];

                for (int i = 0; i < SampleNo; i++)
                {
                    if (TimeLog == false)
                    {
                        // Put the temperature on the graph
                        Time = ConvertFromUnixTimestamp(StartTime + SamplingTime * i);
                        list.Add((double)new XDate(Time), ((short)Samples[i]) / 10.0);
                        DataStream[i] = Time.ToString() + "\t" + (((short)Samples[i]) / 10.0).ToString();

                    }
                    else
                    {
                        // Put the temperature on the graph
                        StartTime = (long)((Samples[i * 4 + 1] * 65536.0) + Samples[i * 4 + 2]);
                        Time = ConvertFromUnixTimestamp(StartTime);
                        list.Add((double)new XDate(Time), ((short)Samples[i*4+3])/10.0);
                        DataStream[i] = Time.ToString() + "\t" + (((short)Samples[i * 4 + 3]) / 10.0).ToString();
                    }
                    
                }
               
                // Fill the symbols with white
                myCurve.Symbol.Fill = new Fill(Color.Blue);

                // Show the x axis grid
                myPane.XAxis.MajorGrid.IsVisible = true;
                // Make the Y axis scale red
                myPane.YAxis.Scale.FontSpec.FontColor = Color.Blue;
                myPane.YAxis.Title.FontSpec.FontColor = Color.Blue;
                // turn off the opposite tics so the Y tics don't show up on the Y2 axis
                myPane.YAxis.MajorTic.IsOpposite = false;
                myPane.YAxis.MinorTic.IsOpposite = false;
                // Don't display the Y zero line
                myPane.YAxis.MajorGrid.IsZeroLine = false;
                // Align the Y axis labels so they are flush to the axis
                myPane.YAxis.Scale.Align = AlignP.Inside;
                // Manually set the axis range
                myPane.YAxis.Scale.Min = (int)tMin - 1;
                myPane.YAxis.Scale.Max = (int)tMax + 1;
                // Enable scrollbars if needed
                zg1.IsShowHScrollBar = false;
                zg1.IsShowVScrollBar = false;
                zg1.IsAutoScrollRange = true;

                // OPTIONAL: Show tooltips when the mouse hovers over a point
                zg1.IsShowPointValues = true;
                zg1.PointDateFormat = "dd/MM/yy HH:mm:ss";
                // Tell ZedGraph to calculate the axis ranges
                // Note that you MUST call this after enabling IsAutoScrollRange, since AxisChange() sets
                // up the proper scrolling parameters
                zg1.AxisChange();
                // Make sure the Graph gets redrawn
                zg1.Invalidate();

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

        }

 
        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            int   sensor;
            byte[] data = new byte[30];
            long sec;
            short sample_16bit;
            double LastSample;

            sensor = SensorNum_CB.SelectedIndex;

            try
            {
                bCfgSend.Enabled = true;
                bDown.Enabled = true;
                
                // Read the sensor's characteristics
                data = ReadWithRetry(SensorTag, Sens_MemBank[sensor], Sens_Addr[sensor], 12);
                
                SensorType_CB.SelectedIndex = (data[S_TYPE_OF] - 1);
                Resolution_TB.Text = data[S_RESL_OF].ToString();
                Tolerance_TB.Text = data[S_TOLR_OF].ToString();
                if ((data[S_DTTY_OF] - 1) < 5)
                {
                    Representation_CB.SelectedIndex = (data[S_DTTY_OF] - 1);
                }
                else
                    Representation_CB.SelectedIndex = 5;

                LowLimit_TB.Text = ((short)(data[S_LLIM_OF+1] + (data[S_LLIM_OF] << 8))).ToString();
                HighLimit_TB.Text = (data[S_HLIM_OF+1] + (data[S_HLIM_OF] << 8)).ToString();
                
                // Read the sensor's status
                data = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_STAT_OF), 2);

                MemFull_CB.Checked = ((data[1] & 0x01) != 0 ? true : false);
                LowViol_CB.Checked = ((data[1] & 0x04) != 0 ? true : false);
                HighViol_CB.Checked = ((data[1] & 0x08) != 0 ? true : false);
                HWFail_CB.Checked = ((data[1] & 0xF0) != 0 ? true : false);
                cb_HWFailure.SelectedIndex = (data[1] >> 4) & 0x0F;


                //Read the sensor's control register
                data = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_CTRL_OF), 2);

                cbReset.Checked = (data[0] & 0x01) != 0 ? true : false;
                cbSetDate.Checked = (data[0] & 0x02) != 0 ? true : false;
                cbFIFOMode.Checked = (data[0] & 0x04) != 0 ? true : false;
                cbDatalogEn.Checked = (data[1] & 0x80) != 0 ? true : false;
                chSam.Checked = (data[1] & 0x40) != 0 ? true : false;
                chTim.Checked = (data[1] & 0x20) != 0 ? true : false;
                rbEvent.Checked = (data[1] & 0x10) != 0 ? true : false;
                cbLimitHighEn.Checked = (data[1] & 0x08) != 0 ? true : false;
                cbLimitLowEn.Checked = (data[1] & 0x04) != 0 ? true : false;

                // Read the sensor's sampling interval
                data = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_SAMI_OF), 2);

                tSampling.Text = (data[1] + (data[0] << 8)).ToString();

                // Read the sensor's low threshold
                data = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_LTHR_OF), 2);

                tLowT.Text = ((short)(data[1] + (data[0] << 8))/10.0).ToString();

                // Read the sensor's high threshold
                data = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_HTHR_OF), 2);

                tHighT.Text = ((short)(data[1] + (data[0] << 8))/10.0).ToString();

                // Read the sensor's sample counter
                data = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_SAMN_OF), 2);

                tSampleNum.Text = (data[1] + (data[0] << 8)).ToString();

                // Read the sensor's start timer
                data = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_STTI_OF), 4);

                sec = data[3] + (data[2] << 8) + (data[1] << 16) + (data[0] << 24);
                dtStartTime.Value = ConvertFromUnixTimestamp(sec);
            
                // Read the sensor's last sample
                data = ReadWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_LAST_OF), 4);
                sample_16bit = (short)((((short)data[0]) << 8) + (short)data[1]);
                LastSample = ((double)(sample_16bit)) / 10.0;
                tLastSample.Text = LastSample.ToString();
                tSamplePosition.Text = ((double)((((short)data[2]) << 8) + (short)data[3])).ToString();

            }
        catch
        {
            MessageBox.Show("Error reading the Tag!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
        }
    }

        private void bCfgSend_Click(object sender, EventArgs e)
        {
            int sensor;
            byte[] data = new byte[10];
            Int16 threshold; 


            try
            {
                sensor = SensorNum_CB.SelectedIndex;
                data[0] = 0;
                data[1] = 0;
            
                // Write Control Register
                if (cbReset.Checked == true)       data[0] |= 0x01;
                if (cbSetDate.Checked == true)     data[0] |= 0x02;
                if (cbFIFOMode.Checked == true) data[0] |= 0x04;
                if (cbDatalogEn.Checked == true)   data[1] |= 0x80;
                if (chSam.Checked == true)         data[1] |= 0x40;
                if (chTim.Checked == true)         data[1] |= 0x20;
                if (rbEvent.Checked == true)       data[1] |= 0x10;
                if (cbLimitHighEn.Checked == true) data[1] |= 0x08;
                if (cbLimitLowEn.Checked == true)  data[1] |= 0x04;
            
                WriteWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_CTRL_OF), 2, data);
         
                // Write Sampling Interval
                data[0] = (byte)(Convert.ToInt16(tSampling.Text) >> 8);
                data[1] = (byte)(Convert.ToInt16(tSampling.Text) & 0x00FF);
                WriteWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_SAMI_OF), 2, data);
                // Write Low Threshold
                threshold = (Int16)(Convert.ToDouble(tLowT.Text) * 10.0);
                data[0] = (byte)(threshold >> 8);
                data[1] = (byte)(threshold & 0x00FF);
                WriteWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_LTHR_OF), 2, data);
                // Write High Threshold
                threshold = (Int16)(Convert.ToDouble(tHighT.Text) * 10.0);
                data[0] = (byte)(threshold >> 8);
                data[1] = (byte)(threshold & 0x00FF);
                WriteWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_HTHR_OF), 2, data);

                //Depending on the FW version may be necessary to swap 4 byte write operation in two separate
                //2 byte write operation
                if (cbSetDate.Checked == true)
                {
                    long sec;

                    sec = ConvertToUnixTimestamp(dtStartTime.Value);
                    data[0] = (byte)(sec >> 24);
                    data[1] = (byte)((sec >> 16) & 0xFF);
                    data[2] = (byte)((sec >> 8) & 0xFF);
                    data[3] = (byte)(sec & 0xFF);

                    WriteWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_STTI_OF), 4, data);
                    //WriteWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_STTI_OF), 2, data);
                    //data[0] = (byte)((sec >> 8) & 0xFF);
                    //data[1] = (byte)(sec & 0xFF);
                    //WriteWithRetry(SensorTag, Sens_MemBank[sensor], (short)(Sens_Addr[sensor] + S_STTI_OF + 2), 2, data);
                }
            }
            catch
            {
                MessageBox.Show("Error writing the Tag!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void groupBox2_Enter(object sender, EventArgs e)
        {

        }

        private void bSetDate_Click(object sender, EventArgs e)
        {
        }

        private void lstTags_SelectedIndexChanged(object sender, EventArgs e)
        {
            byte[] data = new byte[50];
            short SAM_Addr;
            short SAM_MemBank, NoS;
            int i;
            
            if (lstTags.SelectedIndices.Count <= 0)
                return;
            for (i = 0; i < lstTags.Items.Count; i++ )
                lstTags.Items[i].BackColor = Color.White;

            lstTags.Items[lstTags.SelectedIndices[0]].BackColor = Color.Yellow;

            SensorTag = Tags[lstTags.SelectedIndices[0]];

            // Check first if the tag is an A927Z Tag
            data = ReadWithRetry(SensorTag, TID_MB, 0, 4);

            if (!((data[2] == 0x53) && (data[3] == 0x58)))
            {
                bCfgSend.Enabled = false;
                SensorNum_CB.Enabled = false;
                bDown.Enabled = false;
                PAccessCommands.Enabled = true;
                MessageBox.Show("Not an A927Z tag!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            try
            {
                // Read the SAM address in the TID memory bank
                data = ReadWithRetry(SensorTag, TID_MB, SAM_OF, 4);

                SAM_Addr = (short)((data[3] + (data[2] << 8) + (data[1] << 16)) * 2);
                SAM_MemBank = (short)(data[0] & 0x3);

                // Read the Number of Sensors
                data = ReadWithRetry(SensorTag, SAM_MemBank, SAM_Addr, 2);

                NoS = (short)(data[1] + (data[0] << 8));

                SensorNum_CB.Items.Clear();
                for (i = 1; i <= NoS; i++)
                    SensorNum_CB.Items.Add(i);

                for (i = 0; i < NoS; i++)
                {
                    short tmpAddr = (short)((SAM_Addr + 2 + i * SAM_ENTRY_SZ));

                    // Read the SAM entries
                    data = ReadWithRetry(SensorTag, SAM_MemBank, tmpAddr, SAM_ENTRY_SZ);

                    Sens_MemRange[i] = (short)(data[5] + (data[4] << 8));
                    Sens_Addr[i] = (short)((data[3] + (data[2] << 8) + (data[1] << 16)) * 2);
                    Sens_MemBank[i] = (short)(data[0] & 0x3);

                }

                SensorNum_CB.Enabled    = true;
                PAccessCommands.Enabled = true;
                tagInfoToolStripMenuItem.Enabled = true;
            }
            catch
            {
                MessageBox.Show("Error reading the Tag!", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void grpConf_Enter(object sender, EventArgs e)
        {

        }

        private void label16_Click(object sender, EventArgs e)
        {

        }

        private void comboBox1_SelectedIndexChanged_1(object sender, EventArgs e)
        {

        }

        private void SensorType_CB_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void zg1_MouseHover(object sender, EventArgs e)
        {
            
        }

        private void zg1_DoubleClick(object sender, EventArgs e)
        {
            DataLogWav DataLog1 = new DataLogWav();
            DataLog1.Visible = true;
            DataLog1.GraphLogBuild(list);
        }

        private void tabPage1_Click(object sender, EventArgs e)
        {

        }

        private void bRead_Click(object sender, EventArgs e)
        {
            short bank;
            short WordAddress;
            uint Password;
            int  Length = 0;
            byte[] data = new byte[2];

            bank = (short)tBankRead.SelectedIndex;
            WordAddress = Convert.ToInt16(tAddrRead.Text);
            Password = uint.Parse(tPwdRead.Text, System.Globalization.NumberStyles.HexNumber);
            Length = Convert.ToInt16(tBReadLength.Text);

            dGVMemDisplay.Rows.Clear();


            for (int i = 0; i < Length; i++)
            {
                if (Password == 0)
                {
                    data = ReadWithRetry(SensorTag, bank, (short)((WordAddress + i) * 2), 2);
                }
                else
                {
                    data = ReadWithRetry(SensorTag, bank, (short)((WordAddress + i) * 2), 2, (int)Password);
                }
                if ((i % 8) == 0)
                {
                    dGVMemDisplay.Rows.Add();
                    dGVMemDisplay.Rows[i / 8].Cells[0].Style.ForeColor = Color.White;
                    dGVMemDisplay.Rows[i / 8].Cells[0].Style.BackColor = Color.Blue;
                    dGVMemDisplay.Rows[i/8].Cells[0].Value = (WordAddress + i);
                }
                dGVMemDisplay.Rows[i / 8].Cells[i % 8 + 1].Style.ForeColor = Color.White;
                dGVMemDisplay.Rows[i / 8].Cells[i % 8 + 1].Style.BackColor = Color.Green;
                dGVMemDisplay.Rows[i/8].Cells[i%8 + 1].Value = (data[1] + (data[0] << 8));
            }
            for (int i = Length; i < 64; i++)
            {
                if ((i % 8) == 0)
                {
                    dGVMemDisplay.Rows.Add();
                    dGVMemDisplay.Rows[i / 8].Cells[0].Style.ForeColor = Color.White;
                    dGVMemDisplay.Rows[i / 8].Cells[0].Style.BackColor = Color.Blue;
                    dGVMemDisplay.Rows[i / 8].Cells[0].Value = (WordAddress + i);
                }
                dGVMemDisplay.Rows[i / 8].Cells[i % 8 + 1].Style.BackColor = Color.Red;
                dGVMemDisplay.Rows[i / 8].Cells[i % 8 + 1].Value = "";
            }

        }

        private void dGVMemDisplay_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {

        }

        private void bWrite_Click(object sender, EventArgs e)
        {
            short bank;
            short Value;
            short WordAddress;
            uint Password;

            byte[] data = new byte[2];

            bank        = (short)tBankWrite.SelectedIndex;
            Value       = short.Parse(tValueWrite.Text, System.Globalization.NumberStyles.HexNumber);
            WordAddress = Convert.ToInt16(tAddrWrite.Text);
            Password    = uint.Parse(tPwdWrite.Text, System.Globalization.NumberStyles.HexNumber);

            data[0] = (byte)(Value >> 8);
            data[1] = (byte)(Value & 0xFF);

            if (Password == 0)
            {
                WriteWithRetry(SensorTag, bank, (short)(WordAddress * 2), 2, data);
            }
            else
            {
                WriteWithRetry(SensorTag, bank, (short)(WordAddress * 2), 2, data, (int)Password);
            }


        }

        private void bAccLock_Click(object sender, EventArgs e)
        {
            int Action  = 0;
            int Payload = 0;
            uint Password;

            switch (cBLockAction.Text)
            {
                case "ACCESSIBLE": 
                                   Action = 0;
                                   break;
                case "PERMANENT ACCESSIBLE":
                                   Action = 1;
                                   break;
                case "ACCESSIBLE ON SECURE":
                                   Action = 2;
                                   break;
                case "PERMANENT UNACCESSIBLE":
                                   Action = 3;
                                   break;
                default: break;

            }

            switch (tBankLock.Text)
            {
                case "RESERVED (KILL)":
                    Payload = 0xC0000 | (Action << 8);
                    break;
                case "RESERVED(PWD)":
                    Payload = 0x30000 | (Action << 6);
                    break;
                case "EPC":
                    Payload = 0x0C000 | (Action << 4);
                    break;
                case "TID":
                    Payload = 0x03000 | (Action << 2);
                    break;
                case "USER":
                    Payload = 0x00C00 |  Action;
                    break;
                default: break;
            }

            Password    = uint.Parse(tPwdLock.Text, System.Globalization.NumberStyles.HexNumber);

            if (Password == 0)
            {
                LS_0.LockTag_EPC_C1G2(SensorTag, Payload);
            }
            else
            {
                LS_0.LockTag_EPC_C1G2(SensorTag, Payload, (int)Password);
            }

        }

        private void button5_Click(object sender, EventArgs e)
        {
         
        }

        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            
        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            String AboutMsg;

            AboutMsg = " A927Z Temperature Logger Demo\n\n" +
                       " Software Release \t: " + Application.ProductVersion.ToString() + " \n\n" +
                       " Company\t: CAEN RFID S.r.l. \n\n" +
                       " All rights reserved\n";
            MessageBox.Show(AboutMsg,
                            "About", MessageBoxButtons.OK, 
                            MessageBoxIcon.Information);
        }

        private void dumpB_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                
                TestFile = new StreamWriter(saveFileDialog1.FileName.ToString(), false);

                TestFile.WriteLine("              A927Z Temperature Dump (" + DateTime.Today.ToShortDateString() + ")");

                TestFile.WriteLine("");

                for (int i = 0; i < SampleNo; i++)
                {
                    TestFile.WriteLine(DataStream[i]);
                }
                TestFile.Flush();
            }
          
        }

        private void tagInfoToolStripMenuItem_Click(object sender, EventArgs e)
        {
         byte[] data;
         int subprod_type;
         String AboutMsg;
         System.Text.ASCIIEncoding enc = new System.Text.ASCIIEncoding();
         


         data = ReadWithRetry(SensorTag, TID_MB, 0, 4);
         if ((data[2] == 0x53) && (data[3] == 0x58))
         {
             subprod_type = (data[0] << 8) | data[1];
             AboutMsg = "Product Family : A927Z\n\r\n\r";
             AboutMsg += "Product type   : " + subprod_type.ToString() + "\n\r\n\r";
             AboutMsg += "Product status : ";
             data = ReadWithRetry(SensorTag, TID_MB, FWR_OF, 2);
             if (data[0] == 0xFF)
             {
                 int len;

                 AboutMsg += "Prototype\n\r\n\r";
                 AboutMsg += "Note : ";
                 data = ReadWithRetry(SensorTag, RES_MB, RESERVED_NOTE, 32);
                 for (len = 0; len < 32; len++)
                 {
                     if (data[len] == 0) break;
                 }


                 AboutMsg += enc.GetString(data,0,len); 
             }
             else
             {
                 AboutMsg += "Mature\n\r\n\r";
                 AboutMsg += "Note : ";
                 switch (subprod_type)
                 {
                     case 0 : AboutMsg += "Single Sensor Temperature Tag";
                              break;
                     default: break;
                 }
             }
             

             MessageBox.Show(AboutMsg,"Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
         }
        }

        private void bSNNext_Click(object sender, EventArgs e)
        {

        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {

        }


    }
}